;;;   Programm:      ACM-BLITZLAYER.LSP
;;;   Befehlsaufruf: ACM-BLITZLAYER
;;;   Funktion:      Einen neuen Layer anhand der aktuellen Zeichnungseinstellungen erstellen
;;;   Autor:         Gerhard Rampf
;;;                  Kundenspezifische Anpassungen fr AutoCAD und ZWCAD
;;;                  Liebigstr. 3 A
;;;                  86399 Bobingen
;;;                  E-Mail: rampf@geracad.de
;;;   Datum:         17.05.2025
;;;   Plattform:     Alle AutoCAD-Versionen ab Version 2014
(defun c:acm-blitzlayer ( / bll39 bll74 lbl01 lbl02 lbl03 lbl04 lbl05 lbl06 lbl07 lbl08 lbl09 lbl10 lbl11 lbl12 lbl13 lbl14 lbl15 lbl16 lbl18 lbl19 lbl20)
(defun lbl01 (bll01 / bll15 bll16 bll17)
(if (= (vla-get-Lock (setq bll15 (vlax-ename->vla-object (tblobjname "LAYER" (getvar "CLAYER"))))) :vlax-true)
(progn
(setq bll16 1)
(vla-put-Lock bll15 :vlax-false)))
(setq bll17 (vla-AddCircle (lbl03) (vlax-3D-point (list 0.0 0.0 0.0)) 0.05))
(lbl02 bll17 bll01)
(vl-catch-all-apply 'vla-Delete (list bll17))
(if (= bll16 1)
(vla-put-Lock bll15 :vlax-true)))
(defun lbl02 (bll02 bll03 / bll18 bll19 bll20 bll21 bll22 bll23 bll24 bll25 bll26 bll27 bll28 bll29 bll30 bll31 bll32 bll33 bll34 bll35 bll36 bll37 bll38)
(entmake (list (cons 0 "LAYER") (cons 100 "AcDbSymbolTableRecord") (cons 100 "AcDbLayerTableRecord") (cons 2 bll03) (cons 70 0)))
(setq bll18 (vlax-ename->vla-object (tblobjname "LAYER" bll03)))
(if (= (type bll02) 'ENAME)
(setq bll02 (vlax-ename->vla-object bll02)))
(setq bll19 (getvar "CLAYER"))
(setq bll20 (vlax-ename->vla-object (tblobjname "LAYER" bll19)))
(setq bll21 (vlax-get bll20 'TrueColor))
(setq bll22 (vlax-get bll20 'Linetype))
(setq bll23 (vlax-get bll20 'Lineweight))
(setq bll24 (vlax-get bll20 'Material))
(setq bll25 (lbl05 bll19))
(setq bll26 (vlax-get bll02 'Layer))
(setq bll27 (vlax-get bll02 'Color))
(setq bll28 (vlax-get bll02 'TrueColor))
(setq bll29 (vlax-get bll02 'Linetype))
(setq bll30 (vlax-get bll02 'Lineweight))
(if (= bll27 0)
(setq bll31 nil))
(if (= bll27 256)
(setq bll31 (cons 'TrueColor bll21)))
(if
(and
(> bll27 0)
(< bll27 256))
(setq bll31 (cons 'TrueColor bll28)))
(setq bll29 (strcase (vlax-get bll02 'Linetype) 1))
(if (= bll29 "byblock")
(setq bll32 nil))
(if (= bll29 "bylayer")
(setq bll32 (cons 'Linetype bll22)))
(if (not (vl-position bll29 (list "byblock" "bylayer")))
(setq bll32 (cons 'Linetype bll29)))
(if (= bll30 -3)
(setq bll33 (cons 'Lineweight -3)))
(if (= bll30 -2)
(setq bll33 nil))
(if (= bll30 -1)
(setq bll33 (cons 'Lineweight bll23)))
(if (not (vl-position bll30 (list -1 -2 -3)))
(setq bll33 (cons 'Lineweight bll30)))
(setq bll34 (strcase (vlax-get bll02 'Material) 1))
(if (= bll29 "byblock")
(setq bll35 nil))
(if (= bll29 "bylayer")
(setq bll35 (cons 'Material bll24)))
(if (not (vl-position bll29 (list "byblock" "bylayer")))
(setq bll35 (cons 'Material bll34)))
(setq bll36 (lbl04 (vlax-vla-object->ename bll02)))
(if (= bll36 -2)
(setq bll37 nil))
(if (= bll36 -1)
(setq bll37 bll25))
(if (> bll36 -1)
(setq bll37 bll36))
(if bll31
(vl-catch-all-apply 'vlax-put (list bll18 (car bll31) (cdr bll31))))
(if bll32
(vl-catch-all-apply 'vlax-put (list bll18 (car bll32) (cdr bll32))))
(if bll33
(vl-catch-all-apply 'vlax-put (list bll18 (car bll33) (cdr bll33))))
(if bll35
(vl-catch-all-apply 'vlax-put (list bll18 (car bll35) (cdr bll35))))
(if
(and
bll37
(>= bll37 0)
(<= bll37 90))
(progn
(setq bll38 (getvar "CMDECHO"))
(setvar "CMDECHO" 0)
(vl-cmdf "._-layer" "_transparency" bll37 bll03 "")
(setvar "CMDECHO" bll38))))
(defun lbl03 ( / bll39 bll40)
(setq bll39 (vla-get-ActiveDocument (vlax-get-acad-object)))
(if (< (getvar "TILEMODE") 1)
(progn
(if (= (vla-get-MSpace bll39) :vlax-true)
(setq bll40 (vla-get-ModelSpace bll39))
(setq bll40 (vla-get-PaperSpace bll39))))
(setq bll40 (vla-get-ModelSpace bll39))))
(defun lbl04 (bll04 / bll25 bll41)
(if
(and
(getvar "CETRANSPARENCY")
(= (type bll04) 'ENAME))
(progn
(if (not (setq bll25 (cdr (assoc 440 (entget bll04)))))
(setq bll25 -1)
(progn
(if (setq bll41 (vl-position bll25 '(0 100 16777216 33554687 33554684 33554681 33554679 33554676 33554674 33554671 33554669 33554666 33554664 33554661 33554658 33554656 33554653 33554651 33554648 33554646 33554643 33554641 33554638 33554636 33554633 33554630 33554628 33554625 33554623 33554620 33554618 33554615 33554613 33554610 33554607 33554605 33554602 33554600 33554597 33554595 33554592 33554590 33554587 33554585 33554582 33554579 33554577 33554574 33554572 33554569 33554567 33554564 33554562 33554559 33554556 33554554 33554551 33554549 33554546 33554544 33554541 33554539 33554536 33554534 33554531 33554528 33554526 33554523 33554521 33554518 33554516 33554513 33554511 33554508 33554505 33554503 33554500 33554498 33554495 33554493 33554490 33554488 33554485 33554483 33554480 33554477 33554475 33554472 33554470 33554467 33554465 33554462 33554460 33554457)))
(setq bll25 (nth bll41 '(-1 -2 -2 0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41 42 43 44 45 46 47 48 49 50 51 52 53 54 55 56 57 58 59 60 61 62 63 64 65 66 67 68 69 70 71 72 73 74 75 76 77 78 79 80 81 82 83 84 85 86 87 88 89 90)))
(setq bll25 (fix (- 100 (/ (lsh (lsh bll25 24) -24) 2.55)))))))))
bll25)
(defun lbl05 (bll01 / bll25 bll41)
(if
(and
(getvar "CETRANSPARENCY")
(= (type bll01) 'STR)
(tblsearch "LAYER" bll01))
(progn
(if (not (setq bll25 (cdr (assoc 1071 (cdr (car (cdr (assoc -3 (entget (tblobjname "LAYER" bll01) '("AcCmTransparency"))))))))))
(setq bll25 0)
(progn
(if (setq bll41 (vl-position bll25 '(0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41 42 43 44 45 46 47 48 49 50 51 52 53 54 55 56 57 58 59 60 61 62 63 64 65 66 67 68 69 70 71 72 73 74 75 76 77 78 79 80 81 82 83 84 85 86 87 88 89 90 33554687 33554684 33554681 33554679 33554676 33554674 33554671 33554669 33554666 33554664 33554661 33554658 33554656 33554653 33554651 33554648 33554646 33554643 33554641 33554638 33554636 33554633 33554630 33554628 33554625 33554623 33554620 33554618 33554615 33554613 33554610 33554607 33554605 33554602 33554600 33554597 33554595 33554592 33554590 33554587 33554585 33554582 33554579 33554577 33554574 33554572 33554569 33554567 33554564 33554562 33554559 33554556 33554554 33554551 33554549 33554546 33554544 33554541 33554539 33554536 33554534 33554531 33554528 33554526 33554523 33554521 33554518 33554516 33554513 33554511 33554508 33554505 33554503 33554500 33554498 33554495 33554493 33554490 33554488 33554485 33554483 33554480 33554477 33554475 33554472 33554470 33554467 33554465 33554462 33554460 33554457)))
(setq bll25 (nth bll41 '(0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41 42 43 44 45 46 47 48 49 50 51 52 53 54 55 56 57 58 59 60 61 62 63 64 65 66 67 68 69 70 71 72 73 74 75 76 77 78 79 80 81 82 83 84 85 86 87 88 89 90 0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41 42 43 44 45 46 47 48 49 50 51 52 53 54 55 56 57 58 59 60 61 62 63 64 65 66 67 68 69 70 71 72 73 74 75 76 77 78 79 80 81 82 83 84 85 86 87 88 89 90)))
(setq bll25 (fix (- 100 (/ (lsh (lsh bll25 24) -24) 2.55)))))))))
(if
(or
(not bll25)
(< bll25 0)
(> bll25 90))
(setq bll25 0))
bll25)
(defun lbl06 ( / bll44 bll42 bll43)
(if
(and
(setq bll42 (lbl16))
(setq bll43 (open bll42 "w")))
(progn
(setq bll44
(list
"warn"
":dialog{key=\042t_1\042;"
":spacer{height=0.1;}"
":row{"
":image{alignment=top;color=dialog_background;key=\042i_1\042;width=5.5;height=2.7;fixed_width=true;fixed_height=true;}"
":spacer{width=0.05;}"
":text{alignment=top;key=\042t_2\042;width=32;"
(nth (getvar "EXTNAMES") (list "height=8.4;" "height=7.4;"))
"fixed_width=true;fixed_height=true;}}"
":row{"
":spacer{width=5;}"
":button{label=\042OK\042;key=\042b_1\042;width=13;fixed_width=true;is_cancel=true;}"
":spacer{width=5;}}}"))
(while bll44
(write-line (car bll44) bll43)
(setq bll44 (cdr bll44)))
(setq bll43 (close bll43))
bll42)
nil))
(defun lbl07 (bll05 / )
(if bll38 (vl-catch-all-apply 'setvar (list "CMDECHO" bll38)))
(if bll74 (setq *error* bll74))
(vla-EndUndoMark (vla-get-ActiveDocument (vlax-get-acad-object)))
(princ))
(defun lbl08 ( / bll45)
(setq bll45 (strcase (getvar "PRODUCT")))
(if
(and
(= bll45 "AUTOCAD")
(getvar "CGEOCS"))
(setq bll46 T)
(setq bll46 nil))
(if (not bll46)
(lbl18 "AUTOCAD Magazin" "\042acm-blitzlayer\042 kann nur unter AutoCAD ab Version 2014 verwendet werden." "66" "1.9"))
bll46)
(defun lbl09 (bll06 bll07 / bll44 bll42 bll43)
(if
(and
(setq bll42 (lbl16))
(setq bll43 (open bll42 "w")))
(progn
(setq bll44
(list
"alert"
":dialog{"
"key=\042t_1\042;"
":spacer{height=0.1;}"
":text{alignment=top;key=\042t_2\042;"
(strcat "width=" bll06 ";")
(strcat "height=" bll07 ";fixed_width=true;fixed_height=true;}")
":row{"
":spacer{width=5;}"
":button{label=\042OK\042;key=\042b_1\042;width=13;fixed_width=true;is_cancel=true;}"
":spacer{width=5;}}}"))
(while bll44
(write-line (car bll44) bll43)
(setq bll44 (cdr bll44)))
(setq bll43 (close bll43))
bll42)
nil))
(defun lbl10 (bll08 bll09 / bll47 bll48 bll49 bll50 bll51 bll52)
(if (setq bll47 (lbl06))
(progn
(setq bll48 (load_dialog bll47))
(if (not (new_dialog "warn" bll48))
(exit))
(vl-catch-all-apply 'vl-file-delete (list bll47))
(setq bll49 '((25 14 25 17 8) (6 33 27 33 8) (5 32 27 32 8) (3 30 26 30 2) (2 27 13 27 2) (2 26 13 26 2) (3 25 13 25 2) (3 24 13 24 2) (4 23 26 23 2) (4 22 14 22 2) (5 21 13 21 2) (5 20 13 20 2) (6 19 13 19 2) (2 29 27 29 2) (2 28 28 28 2) (4 31 27 31 -16) (3 31 3 31 54) (2 30 2 30 54) (1 26 1 29 54) (6 18 12 18 2) (6 16 6 17 54) (5 18 5 19 54) (2 24 2 25 54) (3 22 3 23 54) (4 20 4 21 54) (7 17 12 17 2) (7 16 12 16 2) (18 27 28 27 2) (18 26 27 26 2) (18 25 27 25 2) (18 24 26 24 2) (15 27 16 27 -16) (14 26 17 26 -16) (18 17 23 17 2) (18 16 22 16 2) (17 20 24 20 2) (17 19 24 19 2) (18 18 23 18 2) (16 22 25 22 2) (17 21 25 21 2) (17 17 17 17 54) (13 17 13 17 54) (14 17 16 17 -16) (13 16 17 16 -16) (16 20 16 20 54) (14 20 14 20 54) (14 19 16 19 -16) (14 18 16 18 -16) (14 25 17 25 -16) (15 24 16 24 -16) (15 22 15 20 -16) (24 16 24 17 -16) (25 18 25 19 -16) (30 24 30 33 8) (28 31 28 33 8) (29 30 29 33 8) (32 28 32 31 8) (28 30 28 30 -16) (31 26 31 32 8) (29 26 29 29 -16) (29 22 29 25 8) (28 24 28 25 -16) (27 22 27 23 -16) (28 20 28 23 8) (27 18 27 21 8) (26 20 26 21 -16) (26 16 26 19 8) (12 7 18 7 2) (12 6 17 6 2) (10 10 19 10 2) (11 9 19 9 2) (11 8 18 8 2) (11 6 11 7 54) (8 12 8 13 54) (9 10 9 11 54) (10 8 10 9 54) (8 14 12 14 2) (9 13 12 13 2) (9 12 12 12 2) (10 11 12 11 2) (8 15 12 15 2) (7 14 7 15 54) (12 4 12 5 54) (20 5 20 7 8) (18 14 21 14 2) (18 13 21 13 2) (18 12 20 12 2) (18 11 20 11 2) (18 15 22 15 2) (19 6 19 7 -16) (13 14 17 14 -16) (13 13 17 13 -16) (13 12 17 12 -16) (14 11 16 11 -16) (13 15 17 15 -16) (23 10 23 13 8) (22 8 22 11 8) (22 12 22 13 -16) (21 10 21 11 -16) (20 8 20 9 -16) (24 12 24 15 8) (23 14 23 15 -16) (21 6 21 9 8) (19 4 19 5 8) (13 5 17 5 2) (13 4 16 4 2) (14 3 15 3 2) (18 4 18 5 -16) (17 3 17 3 -16) (13 3 13 3 54) (14 2 16 2 54)))
(setq bll50 (length bll49))
(setq bll51 0)
(start_image "i_1")
(while (< bll51 bll50)
(setq bll52 (car bll49))
(setq bll49 (cdr bll49))
(vector_image (nth 0 bll52) (nth 1 bll52) (nth 2 bll52) (nth 3 bll52) (nth 4 bll52))
(setq bll51 (1+ bll51)))
(end_image)
(set_tile "t_2" (strcat bll08 "\n\nDie maximal erlaubte Zeichenzahl\nbetrgt " (nth (getvar "EXTNAMES") bll09) ". Folgende Zeichen " (nth (getvar "EXTNAMES") (list "drfen\nverwendet werden:\n                   A - Z\n                   0 - 9\n                   $ _ -" "drfen\nnicht verwendet werden:\n\n         < >/ \\ \042 : ; ? * | , = `"))))
(set_tile "t_1" "AUTOCAD Magazin")
(action_tile "b_1" "(done_dialog)")
(start_dialog)
(unload_dialog bll48))))
(defun lbl11 ( / bll53 bll54)
(setq bll53 (get_tile "eb_01"))
(if
(or
(= (vl-string-trim " " bll53) "")
(not (lbl12 bll53)))
(progn
(lbl10 "Ungltiger Name." (list "31" "255"))
(mode_tile "eb_01" 2)
(setq bll54 nil))
(setq bll54 bll53))
bll54)
(defun lbl12 (bll10 / bll54)
(if (= (getvar "EXTNAMES") 0)
(progn
(if
(or
(= bll10 "")
(snvalid bll10))
(setq bll54 T)
(setq bll54 nil)))
(progn
(setq bll10 (vl-string-trim " " bll10))
(if
(or
(= bll10 "")
(snvalid bll10))
(setq bll54 T)
(setq bll54 nil))))
bll54)
(defun lbl13 ( / bll47 bll48 bll46)
(if (setq bll47 (lbl15))
(progn
(setq bll48 (load_dialog bll47))
(if (not (new_dialog "acmnewlayer" bll48))
(exit))
(vl-catch-all-apply 'vl-file-delete (list bll47))
(if (not (vl-position ame46a_l88-ksabe34_huweem (list "0" "1")))
(setq ame46a_l88-ksabe34_huweem "1"))
(set_tile "tg_01" ame46a_l88-ksabe34_huweem)
(action_tile "b_01" "(if (setq bll46 (lbl14)) (done_dialog))")
(action_tile "b_02" "(setq bll46 nil) (done_dialog)")
(start_dialog)
(unload_dialog bll48)))
bll46)
(defun lbl14 ( / bll53 bll56 bll57)
(setq bll53 (vl-string-trim " " (get_tile "eb_01")))
(if (= bll53 "")
(progn
(setq bll56 0)
(lbl18 "AUTOCAD Magazin" "Bitte Name fr Layer eingeben." "24.5" "1.9")
(set_tile "eb_01" "")
(mode_tile "eb_01" 2))
(progn
(if (not (tblsearch "LAYER" bll53))
(progn
(setq bll57 (lbl11))
(if bll57
(setq bll56 1)
(setq bll56 0)))
(progn
(lbl18 "AUTOCAD Magazin" "Name ist bereits vergeben." "23" "1.9")
(setq bll56 0)
(mode_tile "eb_01" 2)))))
(if (= bll56 1)
(setq bll46 (list bll57 (setq ame46a_l88-ksabe34_huweem (get_tile "tg_01"))))
(setq bll46 nil))
bll46)
(defun lbl15 ( / bll42 bll43 bll44)
(if
(and
(setq bll42 (lbl16))
(setq bll43 (open bll42 "w")))
(progn
(setq bll44
(list
"acmnewlayer"
":dialog{label=\042Neuer Layer\042;initial_focus=\042eb_01\042;"
":spacer{height=0.0;}"
":text{key=\042t_01\042;label=\042&Name:\042;}"
(strcat ":edit_box{key=\042eb_01\042;width=35;edit_limit=" (nth (getvar "EXTNAMES") (list "31" "255")) ";allow_accept=true;}")
":spacer{height=0;}"
":toggle{key=\042tg_01\042;label=\042&Aktuell setzen\042;}"
":spacer{height=0.5;}"
":row{"
":spacer{width=5;}"
":column{width=0;"
":button{key=\042b_01\042;label=\042OK\042;is_default=true;}"
":button{key=\042b_02\042;label=\042Abbrechen\042;is_cancel=true;}}"
":spacer{width=5;}}}"))
(while bll44
(write-line (car bll44) bll43)
(setq bll44 (cdr bll44)))
(setq bll43 (close bll43))
bll42)
nil))
(defun lbl16 ( / bll62 bll63 bll66 bll64 bll65 bll68 bll67 lbl17)
(defun lbl17 (bll11 / bll58 bll59 bll60 bll61 p47_12)
(setq bll58 nil)
(setq bll59 0)
(setq bll60 (strcat "y_$x" (itoa bll59) ".txt"))
(while (findfile (strcat bll11 bll60))
(setq bll59 (1+ bll59))
(setq bll60 (strcat "y_$x" (itoa bll59) ".txt")))
(if (setq bll61 (open (strcat bll11 bll60) "w"))
(progn
(setq bll61 (close bll61))
(setq bll58 T))
(setq bll58 nil))
(vl-file-delete (strcat bll11 bll60))
bll58)
(setq bll62 nil)
(setq bll63 nil)
(if (setq bll64 (getenv "ACAD"))
(progn
(if (setq bll65 (vl-string-search "\073" bll64))
(setq bll66 (substr bll64 1 bll65))
(setq bll66 bll64))
(if (lbl17 (setq bll66 (strcat bll66 "\\")))
(setq bll63 bll66)
(setq bll63 nil)))
(setq bll63 nil))
(if (not bll63)
(progn
(if
(and
(setq bll62 (findfile "acad.exe"))
(setq bll66 (substr bll62 1 (- (strlen bll62) 8)))
(lbl17 bll66))
(setq bll63 bll66)
(setq bll63 nil bll62 nil bll66 nil))))
(if (not bll63)
(progn
(if
(and
(setq bll62 (findfile "acad.mnu"))
(setq bll66 (substr bll62 1 (- (strlen bll62) 8)))
(lbl17 bll66))
(setq bll63 bll66)
(setq bll63 nil bll62 nil bll66 nil))))
(if (not bll63)
(progn
(if
(and
(setq bll62 (findfile "acad.cui"))
(setq bll66 (substr bll62 1 (- (strlen bll62) 8)))
(lbl17 bll66))
(setq bll63 bll66)
(setq bll63 nil bll62 nil bll66 nil))))
(if (not bll63)
(progn
(if
(and
(setq bll62 (findfile "acad.cuix"))
(setq bll66 (substr bll62 1 (- (strlen bll62) 9)))
(lbl17 bll66))
(setq bll63 bll66)
(setq bll63 nil bll62 nil bll66 nil))))
(if (not bll63)
(progn
(if
(and
(setq bll62 (findfile "acad.mnl"))
(setq bll66 (substr bll62 1 (- (strlen bll62) 8)))
(lbl17 bll66))
(setq bll63 bll66)
(setq bll63 nil bll62 nil bll66 nil))))
(if (not bll63)
(progn
(if (lbl17 (getvar "DWGPREFIX"))
(setq bll63 (getvar "DWGPREFIX")))))
(if (not bll63)
(setq bll67 nil)
(progn
(setq bll68 0)
(while (findfile (setq bll67 (strcat bll63 (strcat "acm" (itoa bll68) ".dcl"))))
(setq bll68 (1+ bll68)))))
bll67)
(defun lbl18 (bll12 bll08 bll06 bll07 / bll47 bll48)
(if (setq bll47 (lbl09 bll06 bll07))
(progn
(setq bll48 (load_dialog bll47))
(if (not (new_dialog "alert" bll48))
(exit))
(vl-catch-all-apply 'vl-file-delete (list bll47))
(set_tile "t_2" bll08)
(set_tile "t_1" "AUTOCAD Magazin")
(action_tile "b_1" "(done_dialog)")
(start_dialog)
(unload_dialog bll48))))
(defun lbl19 ( / bll69)
(if (setq bll69 (lbl13))
(progn
(lbl01 (car bll69))
(if (= (cadr bll69) "1")
(progn
(vl-catch-all-apply 'setvar (list "CLAYER" (car bll69)))
(prompt (strcat "\n*Layer \042" (lbl20 (car bll69) 31) "\042 wurde erstellt und aktuell gesetzt.* ")))
(prompt (strcat "\n*Layer \042" (lbl20 (car bll69) 31) "\042 wurde erstellt.* "))))))
(defun lbl20 (bll13 bll14 / bll73 bll70 bll71 bll72)
(setq bll70 (strlen bll13))
(if (> bll70 bll14)
(progn
(setq bll71 (substr bll13 1 (/ (- bll14 3) 2)))
(setq bll72 (substr bll13 (- bll70 (1- (/ (- bll14 3) 2)))))
(setq bll73 (strcat bll71 "\056\056\056" bll72))))
(if bll73
bll73
bll13))
(if (lbl08)
(progn
(vl-load-com)
(sssetfirst nil nil)
(setq bll39 (vla-get-ActiveDocument (vlax-get-acad-object)))
(setq bll74 *error*)
(setq *error* lbl07)
(vla-EndUndoMark bll39)
(vla-StartUndoMark bll39)
(lbl19)
(if bll74
(setq *error* bll74)
(setq *error* nil))
(vla-EndUndoMark bll39)))
(princ))
(terpri)
(princ (strcat "\nAutoLISP-Tool ACM-BLITZLAYER (Copyright  " (substr (rtos (getvar "CDATE")) 1 4) " Gerhard Rampf) geladen. "))
(princ "\nRufen Sie den Befehl mit ACM-BLITZLAYER auf.")
